// 
// Selectable elements are named "SEL".  There are two selectable
// elements for each selection, one for the image and one for the
// name. 
//  
// The id of a selectable element that contains an image is the 
// short identifier.  The id of a selectable element that contains
// the text is "T" plus the short identifier.
//
// To select a target, the background color of the text is set to
// the selected color.  The background color of the image is set
// to the background color only if there is no background image
// set.  The only time the background color is set for the text is
// when the element is selected.
//

var NONE = 'none';
var EMPTY = '';
var test = false;
var displayContextMenu = true;

var tasksURI = '/hmc/ui/z/tas';
var workareaURI = '/hmc/ui/z/was';
var booksURI = '/hmc/ui/z/books';
var launchURI = '/hmc/ui/z/launch';
   
var activeImage = 'url(/images/ui/z/hashbg.gif)';
var selectionName = 'SEL';
var selectedColor =  'dimgray'; 
var selectedTextColor =  'white'; 
var unselectedTextColor =  'black'; 

var ENTER_KEY = 13;
var SPACE_BAR = 32;
var OR_BAR = 124;    
var DISPLAY_TRACE_KEY = 116;   // Display the trace window (Ctrl + Alt + T)
var TOGGLE_MENU_KEY = 109;     // Toggle showing context menu (Ctrl + Alt + M)
var GENERATE_ERROR_KEY = 50;   // Used to test error (Ctrl + Alt + @)
var DISPLAY_HELP_KEY = 104;    // Display help for key (Ctrl + Alt + H)

var DRAG_TYPE_NONE = 0;
var DRAG_TYPE_HELP = 1;
var DRAG_TYPE_TASK = 2;
var DRAG_TYPE_MANAGED_OBJECT = 3;
var dragType = DRAG_TYPE_NONE;
var dragId = NONE;

var workArray = new Array();   // initialized in myGetElementsByName()

//displayTrace();

function init(document)
{
   trace(1, '-> fs.init()');

   if (isBrowserSupported() == true)
   {
      var targets = myGetElementsByName(selectionName, document);
      for (var i = 0; i < targets.length; i++)
      {
         //trace(3, '  targets[i].style.backgroundImage is ' + targets[i].style.backgroundImage);
         //if (targets[i].style.backgroundImage == EMPTY)
            targets[i].style.backgroundImage = NONE;
      }
   }
   else
   {
      trace(1, '  browser is not supported!');
   }

   trace(1, '<- fs.init()');
}

function handleKey(key)
{
   var result = true;  // don't cancel

   if (key == DISPLAY_TRACE_KEY)
      displayTrace();
   else if (key == GENERATE_ERROR_KEY)
      generateError();
   else if (key == TOGGLE_MENU_KEY)
      displayContextMenu = !displayContextMenu;
   else if (key == DISPLAY_HELP_KEY)
      displayHelp();
   else
   {
      message('unknown key: ' + key);
      trace(3, 'unknown key: ' + key);
      result = false;
   }
   
   return result;
}

function setInactive(id, document)
{             
   trace(1, '-> fs.setInactive()');
   trace(3, '   id is ' + id);

   if (id != EMPTY)
   {
      var obj = document.getElementById("I" + id);
      if (obj != null)
         obj.style.backgroundImage = NONE;
   }

   trace(1, '<- fs.setInactive()');
}

function setActive(id, document)
{             
   trace(1, '-> fs.setActive()');
   trace(3, '   id is ' + id);

   if (id != EMPTY)
   {
      var obj = document.getElementById("I" + id);
      if (obj == null)
      {
         trace(2, '   Error, could not find id I' + id + ' in document ' + document);
      }
      else
      {
         obj.style.backgroundColor = EMPTY;
         obj.style.backgroundImage = activeImage;
      }
   }

   trace(1, '<- fs.setActive()');
}

function setUnselected(id, document)
{
   trace(3, '-> fs.setUnselected()');
   trace(3, '   id is ' + id);

   // Get the <td> that contains the image.
   var imageObj = document.getElementById("I" + id);
   if (imageObj == null)
   {
      trace(2, '   Error, could not find id I' + id + ' in document ' + document);
   }
   else
   {
      // Get the <td> that contains the text.
      var textObj = document.getElementById("T" + id);
      if (textObj == null)
      {
         trace(2, '   Error, could not find id T' + id + ' in document ' + document);
      }
      else
      {
         setObjectUnselected(textObj, imageObj);
      }
   }

   trace(3, '<- fs.setUnselected()');
}

function setObjectUnselected(textObj, imageObj)
{
   if ((imageObj.style.backgroundImage == NONE) ||
       (imageObj.style.backgroundImage == activeImage))
      imageObj.style.backgroundColor = EMPTY;

   textObj.style.backgroundColor = EMPTY;
   textObj.style.color = unselectedTextColor;
}

function setSelected(id, document)
{
   trace(3, '-> fs.setSelected()');
   trace(3, '   id is ' + id);

   // Get the <td> that contains the image.
   var imageObj = document.getElementById("I" + id);
   if (imageObj == null)
   {
      trace(2, '   could not find id I' + id + ' in document ' + document);
   }
   else
   {
      // Get the <td> that contains the text.
      var textObj = document.getElementById("T" + id);
      if (textObj == null)
      {
         trace(2, '   could not find id T' + id + ' in document ' + document);
      }
      else
      {
         setObjectSelected(textObj, imageObj);
      }
   }

   trace(3, '<- fs.setSelected()');
}

function setObjectSelected(textObj, imageObj)
{
   if (imageObj.style.backgroundImage == NONE)
      imageObj.style.backgroundColor = selectedColor;

   textObj.style.backgroundColor = selectedColor;
   textObj.style.color = selectedTextColor;
}

function unselectAll(document)
{
   trace(3, '-> fs.unselectAll()');

   var targets = myGetElementsByName(selectionName, document);
   for (var i = 0; i < targets.length; i++)
   {
      // Is this the text element in the selection?
      if (targets[i].id.charAt(0) == 'T')
      {
         // See if the text element is selected.
         if (targets[i].style.backgroundColor == selectedColor)
         {
            // Unselect the text element.
            targets[i].style.backgroundColor = EMPTY;
            targets[i].style.color = unselectedTextColor;

            // Get the image element for this text element.
            var imgId = "I" + targets[i].id.substr(1);
            var img = document.getElementById(imgId);
            
            // Unselect the image element.
            if (img.style.backgroundImage == NONE)
               img.style.backgroundColor = EMPTY;
         }
      }
   }

   trace(3, '<- fs.unselectAll()');
}

function selectAll(document)
{
   trace(3, '-> fs.selectAll()');

   var targets = myGetElementsByName(selectionName, document);
   for (var i = 0; i < targets.length; i++)
   {
      // Is this the text element in the selection?
      if (targets[i].id.charAt(0) == 'T')
      {
         // See if the text element is selected.
         if (targets[i].style.backgroundColor != selectedColor)
         {
            // Get the image element for this text element.
            var imgId = "I" + targets[i].id.substr(1);
            var img = document.getElementById(imgId);
            
            // Select the image element.
            setObjectSelected(targets[i], img);
         }
      }
   }

   trace(3, '<- fs.selectAll()');
}

function toggleSelection(id, document, singleSelection)
{
   trace(3, '-> fs.toggleSelection()');
   trace(3, '   id is ' + id);

   var imageObj = document.getElementById("I" + id);
   if (imageObj == null)
   {
      trace(2, '   could not find id I' + id + ' in document ' + document);
   }
   else
   {
      var textObj = document.getElementById("T" + id);
      if (textObj == null)
      {
         trace(2, '   could not find id T' + id + ' in document ' + document);
      }
      else
      {
         if (isSelected(textObj))
         {
            setObjectUnselected(textObj, imageObj);
         } 
         else
         {
            // single selection panel?
            if (singleSelection == true)
               unselectAll(document);

            setObjectSelected(textObj, imageObj);
         } 
      }
   }

   trace(3, '<- fs.toggleSelection()');
}

function isSelected(textObj)
{
   if ((textObj != null) && (textObj.style.backgroundColor == selectedColor))
      return true;
   return false;
}

function changeSelection(id, document, prevSelection)
{
   trace(3, '-> fs.changeSelection()');
   trace(3, '   id is ' + id);

   if (prevSelection != null)
   {
      var obj = document.getElementById("T" + prevSelection);
      obj.style.color = "black";
      obj = document.getElementById("I" + prevSelection);
      if (obj != null)
         obj.style.backgroundColor = NONE;
   }

   setSelected(id, document);
   obj = document.getElementById("T" + id);
   obj.style.color = "white";
   
   trace(3, '<- fs.changeSelection()');
}

// 
// document.getElementsByName() returns 0 objects in IE
// so I have to check myself.
//
function myGetElementsByName(name, document)
{
   if (isIE)
   {
      workArray.length = 0;
      for (var i = 0; i < document.all.length; i++)  // 'document.all' is IE only
      {
         if (document.all[i].name == name)
            workArray[workArray.length] = document.all[i];
      }
      return workArray;
   }
   else
   {
      return document.getElementsByName(name);
   }
}

function getIdFromEvent(event)
{
   trace(3, '<> fs.getIdFromEvent()');
   if (event.target)
   {
       // NN
       trace(3, '   event.target.id is ' + event.target.id);
       trace(3, '   event.currentTarget.id is ' + event.currentTarget.id);
       if (event.target.id == '')
           return getId(event.currentTarget.id); 
       
       return getId(event.target.id);          
   }
   else
   {                                          // IE
      var id = event.srcElement.id;
      if (event.srcElement.id == '')
         id = event.srcElement.id;
         // id = event.srcElement.parentElement.parentElement.id;
      
      return getId(id);
   }
}

function getId(theId)
{
   trace(3, '-> fs.getId, id argument is ' + theId);

   if (theId == undefined)
      return theId;
  
   var id = String(theId);
   // A -> F are used as the hex id
   if ((id.charAt(0) >= 'G') && (id.charAt(0) <= 'Z'))
      id = id.substr(1);

   trace(3, '<- fs.getId, returning id ' + id);
   return id;
}

function message(text)
{
   trace(3, text);
   if (test == true)
      window.alert(text);
}

// tell the user something
function tell(title, text, msgNumber)
{
   window.alert(title + "\n\n" + text);
}

function displayHelp()
{
   var text = "<html><body><dl>"
            + "<dt style='font-weight:bold;'>Ctrl+Alt+H</dt><dd>Display this window.</dd>"
            + "<dt style='font-weight:bold;'>Ctrl+Alt+T</dt><dd>Display the trace window.</dd>"
            + "<dt style='font-weight:bold;'>Ctrl+Alt+M</dt><dd>Toggle turning on and off context menus.  When context menus are off the browsers context menu will display.</dd>"
            + "<dt style='font-weight:bold;'>Ctrl+Alt+@</dt><dd>Test logging from JavaScript.</dd>"
            + "</dl></body</html>";
   var features = (isIE) ? "width=400,height=210,left=0,top=0" : 
                           "width=400,height=210,screenX=0,screenY=0";
   var helpWindow = window.open(null, 'Keys Help', features);
   helpWindow.document.write(text);
}

function reloadTC()
{
   //top.frames[1].location.reload( true );
}


